/*
 * Decompiled with CFR 0.152.
 */
package com.exfantasy.mclib.Utils;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.PartEntity;

public class EntityPointer {
    public static HitResult raycastForEntity(Level level, Entity originEntity, float distance, boolean checkForBlocks) {
        Vec3 start = originEntity.m_146892_();
        Vec3 end = originEntity.m_20154_().m_82541_().m_82490_((double)distance).m_82549_(start);
        return EntityPointer.raycastForEntity(level, originEntity, start, end, checkForBlocks);
    }

    public static HitResult checkEntityIntersecting(Entity entity, Vec3 start, Vec3 end, float bbInflation) {
        Vec3 hitPos = null;
        if (entity.isMultipartEntity()) {
            for (PartEntity p : entity.getParts()) {
                Vec3 hit = p.m_20191_().m_82400_((double)bbInflation).m_82371_(start, end).orElse(null);
                if (hit == null) continue;
                hitPos = hit;
                break;
            }
        } else {
            hitPos = entity.m_20191_().m_82400_((double)bbInflation).m_82371_(start, end).orElse(null);
        }
        if (hitPos != null) {
            return new EntityHitResult(entity, hitPos);
        }
        return BlockHitResult.m_82426_((Vec3)end, (Direction)Direction.UP, (BlockPos)BlockPos.m_274446_((Position)end));
    }

    public static LivingEntity raycastForEntityTo(Level level, Entity originEntity, float distance, boolean checkForBlocks) {
        Vec3 startVec = originEntity.m_20299_(1.0f);
        Vec3 lookVec = originEntity.m_20252_(1.0f);
        Vec3 endVec = startVec.m_82520_(lookVec.f_82479_ * (double)distance, lookVec.f_82480_ * (double)distance, lookVec.f_82481_ * (double)distance);
        HitResult hitResult = EntityPointer.raycast(level, startVec, endVec, checkForBlocks);
        if (hitResult != null && hitResult.m_6662_() == HitResult.Type.BLOCK && checkForBlocks) {
            return null;
        }
        AABB aabb = new AABB(startVec, endVec).m_82377_(1.0, 1.0, 1.0);
        LivingEntity closestLivingEntity = null;
        double closestDist = Double.MAX_VALUE;
        for (Entity entity : level.m_6443_(LivingEntity.class, aabb, e -> !e.m_5833_() && e != originEntity && e.m_21223_() > 0.0f)) {
            Vec3 closestPoint = entity.m_20182_().m_82520_(0.0, (double)(entity.m_20206_() / 2.0f), 0.0);
            double dist = startVec.m_82557_(closestPoint);
            if (!(dist < closestDist) || !EntityPointer.isOnRay(startVec, endVec, closestPoint)) continue;
            closestDist = dist;
            closestLivingEntity = (LivingEntity)entity;
        }
        return closestLivingEntity;
    }

    private static HitResult raycast(Level level, Vec3 startVec, Vec3 endVec, boolean checkForBlocks) {
        ClipContext context = new ClipContext(startVec, endVec, checkForBlocks ? ClipContext.Block.COLLIDER : ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, null);
        return level.m_45547_(context);
    }

    private static boolean isOnRay(Vec3 startVec, Vec3 endVec, Vec3 point) {
        Vec3 direction = endVec.m_82546_(startVec);
        Vec3 toPoint = point.m_82546_(startVec);
        double dotProduct = direction.m_82526_(toPoint);
        double lengthSquared = direction.m_82556_();
        return dotProduct >= 0.0 && dotProduct <= lengthSquared;
    }

    private static boolean canHitWithRaycast(Entity entity) {
        return entity.m_6087_() && entity.m_6084_();
    }

    public static HitResult raycastForEntity(Level level, Entity originEntity, Vec3 start, Vec3 end, boolean checkForBlocks) {
        return EntityPointer.internalRaycastForEntity(level, originEntity, start, end, checkForBlocks, 0.0f, EntityPointer::canHitWithRaycast);
    }

    private static HitResult internalRaycastForEntity(Level level, Entity originEntity, Vec3 start, Vec3 end, boolean checkForBlocks, float bbInflation, Predicate<? super Entity> filter) {
        BlockHitResult blockHitResult = null;
        if (checkForBlocks) {
            blockHitResult = level.m_45547_(new ClipContext(start, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, originEntity));
            end = blockHitResult.m_82450_();
        }
        AABB range = originEntity.m_20191_().m_82369_(end.m_82546_(start));
        ArrayList<HitResult> hits = new ArrayList<HitResult>();
        List entities = level.m_6249_(originEntity, range, filter);
        for (Entity target : entities) {
            HitResult hit = EntityPointer.checkEntityIntersecting(target, start, end, bbInflation);
            if (hit.m_6662_() == HitResult.Type.MISS) continue;
            hits.add(hit);
        }
        if (!hits.isEmpty()) {
            hits.sort(Comparator.comparingDouble(o -> o.m_82450_().m_82557_(start)));
            return (HitResult)hits.get(0);
        }
        if (checkForBlocks) {
            return blockHitResult;
        }
        return BlockHitResult.m_82426_((Vec3)end, (Direction)Direction.UP, (BlockPos)BlockPos.m_274446_((Position)end));
    }

    public static void sendParticleCircle(ServerLevel level, Entity entity, SimpleParticleType particleType, float radius, int count) {
        double posX = entity.m_20185_();
        double posY = entity.m_20186_() + (double)entity.m_20206_() * 0.5;
        double posZ = entity.m_20189_();
        RandomSource random = RandomSource.m_216327_();
        for (int i = 0; i < count; ++i) {
            double angle = (double)i * (Math.PI * 2 / (double)count);
            double offsetX = (double)radius * Math.cos(angle);
            double offsetZ = (double)radius * Math.sin(angle);
            level.m_8767_((ParticleOptions)particleType, posX + (offsetX += random.m_188500_() * 0.1 - 0.05), posY, posZ + (offsetZ += random.m_188500_() * 0.1 - 0.05), 1, 0.0, 0.0, 0.0, 0.05);
        }
    }

    public static Optional<LivingEntity> findTargetedEntity(LivingEntity player, float length) {
        HitResult hit = player.m_19907_(5.0, 1.0f, false);
        Vec3 eyePos = player.m_20299_(1.0f);
        AABB searchBox = new AABB(eyePos, eyePos).m_82400_((double)length);
        List entities = player.m_9236_().m_45976_(LivingEntity.class, searchBox);
        return entities.stream().filter(entity -> entity != player).filter(entity -> entity.m_6084_()).filter(entity -> entity.m_21223_() > 0.0f).min((e1, e2) -> Double.compare(e1.m_20238_(hit.m_82450_()), e2.m_20238_(hit.m_82450_())));
    }

    public static Entity getPointedEntity(Player player, double range) {
        Level world = player.m_9236_();
        Vec3 eyePos = player.m_20299_(1.0f);
        Vec3 lookVec = player.m_20252_(1.0f);
        Vec3 targetPos = eyePos.m_82520_(lookVec.f_82479_ * range, lookVec.f_82480_ * range, lookVec.f_82481_ * range);
        ClipContext context = new ClipContext(eyePos, targetPos, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player);
        BlockHitResult hitResult = world.m_45547_(context);
        if (hitResult.m_6662_() == HitResult.Type.MISS) {
            return null;
        }
        AABB aabb = player.m_20191_().m_82369_(lookVec.m_82490_(range)).m_82377_(1.0, 1.0, 1.0);
        Entity pointedEntity = null;
        double closestDist = range;
        for (Entity entity : world.m_6249_((Entity)player, aabb, e -> !e.m_5833_())) {
            double dist;
            AABB entityBox = entity.m_20191_().m_82400_((double)entity.m_6143_());
            Optional optional = entityBox.m_82371_(eyePos, targetPos);
            if (entityBox.m_82390_(eyePos)) {
                if (!(closestDist >= 0.0)) continue;
                pointedEntity = entity;
                closestDist = 0.0;
                continue;
            }
            if (!optional.isPresent() || !((dist = eyePos.m_82557_((Vec3)optional.get())) < closestDist)) continue;
            closestDist = dist;
            pointedEntity = entity;
        }
        return pointedEntity;
    }

    public static LivingEntity getPointedLivingEntity(Player player, double range) {
        LivingEntity livingEntity;
        Entity entity;
        Level world = player.m_9236_();
        Vec3 eyePos = player.m_20299_(1.0f);
        Vec3 lookVec = player.m_20252_(1.0f);
        Vec3 targetPos = eyePos.m_82520_(lookVec.f_82479_ * range, lookVec.f_82480_ * range, lookVec.f_82481_ * range);
        ClipContext context = new ClipContext(eyePos, targetPos, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player);
        BlockHitResult hitResult = world.m_45547_(context);
        if (hitResult.m_6662_() == HitResult.Type.ENTITY && (entity = ((EntityHitResult)hitResult).m_82443_()) instanceof LivingEntity && (livingEntity = (LivingEntity)entity) != player && livingEntity.m_21223_() > 0.0f) {
            return livingEntity;
        }
        AABB aabb = player.m_20191_().m_82369_(lookVec.m_82490_(range)).m_82377_(1.0, 1.0, 1.0);
        LivingEntity pointedLivingEntity = null;
        double closestDist = range;
        for (Entity entity2 : world.m_6443_(LivingEntity.class, aabb, e -> !e.m_5833_() && e != player && e.m_21223_() > 0.0f)) {
            Vec3 toEntity;
            Vec3 closestPoint = entity2.m_20182_().m_82520_(0.0, (double)(entity2.m_20206_() / 2.0f), 0.0);
            double dist = eyePos.m_82557_(closestPoint);
            if (!(dist < closestDist) || !((toEntity = closestPoint.m_82546_(eyePos)).m_82526_(lookVec) > 0.0)) continue;
            closestDist = dist;
            pointedLivingEntity = (LivingEntity)entity2;
        }
        return pointedLivingEntity;
    }
}

